//*****************************************************************************
//
//  Sample Program for Battery
//
//  Target Machine : CPT-711
//
//  Function:
//  unsigned get_vmain(void)   : Get voltage level of the main power supply.
//  unsigned get_vbackup(void) : Get voltage level of the backup battery.
//
//           The voltage level of the battery in units of mV(mili-volt).
//
//  SYNTECH INFORMATION CO., LTD.
//
//*****************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int  iV1, iV2;

    clr_scr ();
    gotoxy (4, 1);
    puts ("BATTERY TEST");

    iV1 = get_vmain();
    iV2 = iV1 % 1000;
    iV1 /= 1000;

    gotoxy (4, 3);
    puts ("MAIN:");
    printf ("%1d.%03d V", iV1, iV2);

    iV1 = get_vbackup ();
    iV2 = iV1 % 1000;
    iV1 /= 1000;

    gotoxy (2, 5);
    puts ("BACKUP:");
    printf ("%1d.%03d V", iV1, iV2);

    while (getchar() != KEY_ESC);
    }

//-------------------------------------------------------------------------//
